% Figures_5_6_7_8.m
% 
% driving process figures
% 
% "The Past and Future of U.S. Structural Change" 
% Andrew Foerster, Andreas Hornstein, Pierre-Daniel Sarte, Mark Watson
% September 2025
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 

% -- Clear Workspace -- %
restoredefaultpath;
clear;
clc;
close all;

% -- File Directories -- % 
datadir = 'Data\DataReplication\DataFinal\'; 
outdir  = 'Tables\';
figdir  = 'Figures\';
matdir  = 'Output\';

% -- Add paths -- %
addpath('Functions\');
addpath('Utilities\')
addpath('Data\')

% -- Load Data == %
load_data;
period_lower = 20;       % Shortest Period 
Share_mat = sV_mat;
T = size(Share_mat,1);
% Compute q
q = floor(2*T/period_lower);

% Log Prices
py = y ./ yq;
py = py(1:T,:);

% Consumption
c   = (squeeze(ee(:,1,:)))';    % c is nominal expenditures on consumption, ee contains final demand of PCE, Private Fixed Inv, Gov Cons, Gov Fixed Inv, and Inv + NX produced by each sector 
E   = (sum(c(:,:),2));          % total consumption expenditures
theta_mean = mean(theta(:,:),1);
s_c = sum(theta_mean(:,1:3)); 

% Labor
labor = nq(1:T,:);

% Figure 5
i_loc = [3 1 2 4 5];
for i = 1:5
    figure('Units','Inches','Position',[1 1 2 2]);

    % jj = i_loc(i);
    I_trend = 0;
    tmp = [NaN;d_tfp(2:T,i)];
    tmp_trend = [NaN;LF_Proj(d_tfp(2:T,i),q,I_trend)];
    hold on
    plot(calvec,100*tmp,'- k','LineWidth',1)
    plot(calvec,100*tmp_trend,'- b','LineWidth',2)
    ylim([-10 10]);
    if i_loc(i) == 1
        ylim([-10 15])
    elseif i_loc(i) == 5
        ylim([-5 5])
    end

    xlim([1940 2020]);
    % if (i_loc(i) == 1) || (i_loc(i) == 3) || (i_loc(i) == 5)
    %     ylabel('Percentage Points','FontSize',ax_axis_lab);
    % end
    % if (i_loc(i) == 4) || (i_loc(i) == 5)
    %     xlabel('Year','FontSize',ax_axis_lab);
    % end   
    % title(SecName{i},'FontSize',ax_fs);
    % ax = gca;
    % ax.FontSize = ax_fs;
    grid on;
    box on
    print('-depsc',[figdir 'Figure_5_' num2str(i_loc(i))])
end


% -------------- Construct IBTC ----------------
% --- Materials ---
% -- Phi Durable Goods and IPP Services -- %
eps_m = [2.00 1.67 1.10 0.86 0.69];
trend_eta_m  = NaN(T,nS);
eta_m  = NaN(T,nS);
for jj = 1:5
    % Relative Prices and Omega: Durable Goods relative to IPP 
    rel_phi(:,1) = log((phi(2,jj,:)./phi(3,jj,:)));
    rel_price(:,1) = log((py(:,2)./py(:,3))); 
    
    % Construct MIBTC consistent with (13)
    Z_m = exp((1/eps_m(1,jj))*(rel_phi-(1-eps_m(1,jj))*rel_price));
    z_m = Z_m./(1+Z_m);
    tmp = z_m;    
    I_trend = 1;
    eta_m(:,jj) = z_m;
    trend_eta_m(:,jj) = LF_Proj(z_m,q,I_trend);    
end
eps_x = [1.42 1.25 0.66 1.03 1.12];
trend_eta_x  = NaN(T,nS);
eta_x  = NaN(T,nS);
for jj = 1:5
    % Relative Prices and Omega: Durable Goods relative to IPP 
    rel_omega(:,1) = log((omega(2,jj,:)./omega(3,jj,:)));
    rel_price(:,1) = log((py(:,2) ./ py(:,3))); 
    % Construct IBTC consistent with (13)
    Z_x = exp((1/eps_x(1,jj))*(rel_omega-(1-eps_x(1,jj))*rel_price));
    z_x = Z_x./(1+Z_x);
    eta_x(:,jj) = z_x;
    I_trend = 1;
    trend_eta_x(:,jj) = LF_Proj(z_x,q,I_trend);
end

% -- Figure 6 -- %
i_plot = [2 4 5];
jj = 0;
for i = 1:length(i_plot)
    jj = jj+1;
    figure('Units','Inches','Position',[1 1 2 2]);
    hold on
    plot(calvec,eta_x(:,i_plot(i)),'-k','LineWidth',1);
    plot(calvec,trend_eta_x(:,i_plot(i)),'-b','LineWidth',2);
    xlim([1940 2020]);
    % ylim([0.3 1.0]);
    % title([SecName{i_plot(i)} ' Investment'],'FontSize',ax_fs);
    % ax = gca;
    % ax.FontSize = ax_fs;
    grid on;
    box on
    print('-depsc',[figdir 'Figure_6_' num2str(jj)])

    % subplot(2,3,jj+3);
    figure('Units','Inches','Position',[1 1 2 2]);
    hold on
    plot(calvec,eta_m(:,i_plot(i)),'-k','LineWidth',1);
    plot(calvec,trend_eta_m(:,i_plot(i)),'-b','LineWidth',2);
    xlim([1940 2020]);
    % ylim([0.3 1.0]);
    % title([SecName{i_plot(i)} ' Materials'],'FontSize',ax_fs);
    % ax = gca;
    % ax.FontSize = ax_fs;
    grid on;
    box on
    print('-depsc',[figdir 'Figure_6_' num2str(jj+3)])
end


% Figure 7
% Calibration for Theta Nondurables and Services Using Results from
% Comin, Lashkari, and Mestieri (2021)
epsilon_c = 1.65; 
sigma = 0.26;

E_n = (1-s_c)*E;         % total consumption expenditures on Nondurable Goods and Services
omega_j = theta(:,5)./(theta(:,5)+theta(:,4)); 
omega_b = 1 - omega_j;      % base good is Nondurable Goods
ln_omega_j = log(omega_j);  
ln_omega_b = log(omega_b);
ln_rel_price = log(py(:,5)./py(:,4));
ratio_en_pyb = E_n./py(:,4); 
real_exp_snd = log(ratio_en_pyb);

% Preference Shock
ln_Theta_t      = ln_omega_j - (1-sigma)*ln_rel_price - (1-sigma)*(epsilon_c-1)*(real_exp_snd) - epsilon_c*ln_omega_b; % Solve for Theta_j from eq. (52)
Theta_t     = exp(ln_Theta_t);
ln_omega_check = (1-sigma)*ln_rel_price + (1-sigma)*(epsilon_c-1)*(real_exp_snd) + epsilon_c*ln_omega_b + ln_Theta_t;
price_effect = (1-sigma)*ln_rel_price;
income_effect = (1-sigma)*(epsilon_c-1)*(real_exp_snd);
omegab_effect = epsilon_c*ln_omega_b;
I_trend = 1;
trend_ln_Theta_t = LF_Proj(ln_Theta_t,q,1);
trend_Theta_t = exp(trend_ln_Theta_t);

% -- Figure 7 -- %
figure('Units','Inches','Position',[1 1 6 3]);
hold on
plot(calvec,Theta_t,'-k','LineWidth',1)
plot(calvec,trend_Theta_t,'-b','LineWidth',2)
% ax = gca;
% ax.FontSize = ax_fs;
grid on;
box on
% Save the figure as a png file
print('-depsc',[figdir 'Figure_7'])

% -- Labor -- %

i_loc = [3 1 2 4 5];
for i = 1:5
    figure('Units','Inches','Position',[1 1 2 2]);
    jj = i_loc(i);
    I_trend = 1;
    tmp = labor(:,i);
    tmp_trend = LF_Proj(labor(:,i),q,I_trend);
    trend_labor = tmp_trend;
    hold on
    plot(calvec,tmp,'- k','LineWidth',1)
    plot(calvec,tmp_trend,'- b','LineWidth',2)
    % ylim([-4 6]);
    xlim([1940 2020]);
    % if (i_loc(i) == 1) || (i_loc(i) == 3) || (i_loc(i) == 5)
        % ylabel('Percentage Points','FontSize',ax_axis_lab);
    % end
    % if (i_loc(i) == 4) || (i_loc(i) == 5)
        % xlabel('Year','FontSize',ax_axis_lab);
    % end   
    % title(SecName{i},'FontSize',ax_fs);
    % ax = gca;
    % ax.FontSize = ax_fs;
    grid on;
    box on
    print('-depsc',[figdir 'Figure_8_' num2str(i_loc(i))])
end
% Save the figure as a png file
% fname = ['Figure_8'];
% figure_to_png(figdir,fname);
% close(fig); 


%
save([matdir 'driving_processes.mat'], ...
    'labor','trend_labor',...
    'eta_x', 'trend_eta_x', 'eps_x', ...
    'eta_m', 'trend_eta_m', 'eps_m', ...
    'Theta_t', 'trend_Theta_t', ...
    'epsilon_c','sigma','ratio_en_pyb');